<?php
require_once __DIR__.'/partials.php';
$page = max(1, (int)($_GET['page'] ?? 1)); $perPage = 9; $offset = ($page-1)*$perPage;
$st = db()->query("SELECT COUNT(*) AS c FROM posts WHERE status='published'"); $total = (int)($st->fetch()['c'] ?? 0);
$ps = db()->prepare("SELECT p.id,p.title,p.slug,p.summary,p.image,p.published_at,c.name AS cat_name,c.slug AS cat_slug FROM posts p LEFT JOIN categories c ON c.id=p.category_id WHERE p.status='published' ORDER BY p.published_at DESC, p.id DESC LIMIT :lim OFFSET :off");
$ps->bindValue(':lim', $perPage, PDO::PARAM_INT); $ps->bindValue(':off', $offset, PDO::PARAM_INT); $ps->execute(); $posts = $ps->fetchAll(); $ps->closeCursor();
header_html('Anasayfa');
?>
<?php if($posts): ?>
  <?php $first = $posts[0]; ?>
  <section class="grid md:grid-cols-2 gap-6">
    <a class="card" href="article.php?s=<?= e($first['slug']) ?>">
      <img src="<?= e($first['image'] ?: 'https://picsum.photos/900/500') ?>" alt="<?= e($first['title']) ?>">
      <div class="body"><div class="badge"><?= e($first['cat_name'] ?? 'Genel') ?></div><h2 class="text-2xl font-semibold mt-2"><?= e($first['title']) ?></h2><p class="text-gray-600 mt-1"><?= e(mb_substr($first['summary'] ?? '',0,140)) ?>...</p></div>
    </a>
    <div class="grid sm:grid-cols-2 gap-4">
      <?php foreach(array_slice($posts,1,4) as $p): ?>
        <a class="card" href="article.php?s=<?= e($p['slug']) ?>"><img src="<?= e($p['image'] ?: 'https://picsum.photos/800/400') ?>" alt="<?= e($p['title']) ?>"><div class="body"><div class="badge"><?= e($p['cat_name'] ?? 'Genel') ?></div><h3 class="font-semibold"><?= e($p['title']) ?></h3></div></a>
      <?php endforeach; ?>
    </div>
  </section>
  <section class="mt-8 grid sm:grid-cols-2 lg:grid-cols-3 gap-6">
    <?php foreach(array_slice($posts,5) as $p): ?>
      <a class="card" href="article.php?s=<?= e($p['slug']) ?>"><img src="<?= e($p['image'] ?: 'https://picsum.photos/800/400') ?>" alt="<?= e($p['title']) ?>"><div class="body"><div class="badge"><?= e($p['cat_name'] ?? 'Genel') ?></div><h3 class="font-semibold"><?= e($p['title']) ?></h3><p class="text-gray-600 mt-1"><?= e(mb_substr($p['summary'] ?? '',0,100)) ?>...</p></div></a>
    <?php endforeach; ?>
  </section>
  <?= paginate($total,$perPage,$page,'index.php') ?>
<?php else: ?><div class="notice">Henüz yayınlanmış haber yok.</div><?php endif; ?>
<?php footer_html(); ?>
