<?php
require_once __DIR__.'/partials.php';
$slug = trim($_GET['c'] ?? '');
$st = db()->prepare("SELECT id,name,slug FROM categories WHERE slug=? LIMIT 1"); $st->execute([$slug]); $cat = $st->fetch(); $st->closeCursor();
if(!$cat){ die('Kategori bulunamadı.'); }
$page = max(1, (int)($_GET['page'] ?? 1)); $perPage = 9; $offset = ($page-1)*$perPage;
$ct = db()->prepare("SELECT COUNT(*) AS c FROM posts WHERE status='published' AND category_id=?"); $ct->execute([$cat['id']]); $total = (int)($ct->fetch()['c'] ?? 0);
$ps = db()->prepare("SELECT id,title,slug,summary,image,published_at FROM posts WHERE status='published' AND category_id=? ORDER BY published_at DESC, id DESC LIMIT :lim OFFSET :off");
$ps->bindValue(':lim', $perPage, PDO::PARAM_INT); $ps->bindValue(':off', $offset, PDO::PARAM_INT); $ps->execute([$cat['id']]); $posts = $ps->fetchAll(); $ps->closeCursor();
header_html('Kategori: '.$cat['name']);
?>
<h1 class="text-2xl font-bold mb-4">Kategori: <?= e($cat['name']) ?></h1>
<section class="grid sm:grid-cols-2 lg:grid-cols-3 gap-6">
<?php foreach($posts as $p): ?>
  <a class="card" href="article.php?s=<?= e($p['slug']) ?>">
    <img src="<?= e($p['image'] ?: 'https://picsum.photos/800/400') ?>" alt="<?= e($p['title']) ?>">
    <div class="body"><h3 class="font-semibold"><?= e($p['title']) ?></h3><p class="text-gray-600 mt-1"><?= e(mb_substr($p['summary'] ?? '',0,100)) ?>...</p></div>
  </a>
<?php endforeach; ?>
</section>
<?= paginate($total,$perPage,$page,'category.php?c='.e($cat['slug'])) ?>
<?php footer_html(); ?>
