<?php
require_once __DIR__.'/inc/auth.php'; require_login(); csrf_check();
if($_SERVER['REQUEST_METHOD']==='POST'){
  $action = $_POST['action'] ?? ''; $id = (int)($_POST['id'] ?? 0);
  if($action==='delete' && $id){ db()->prepare("DELETE FROM posts WHERE id=? LIMIT 1")->execute([$id]); }
  elseif(($action==='publish' || $action==='unpublish') && $id){
    if($action==='publish'){ db()->prepare("UPDATE posts SET status='published', published_at=NOW() WHERE id=?")->execute([$id]); }
    else { db()->prepare("UPDATE posts SET status='draft' WHERE id=?")->execute([$id]); }
  }
}
$ps = db()->query("SELECT p.id,p.title,p.slug,p.status,p.image,p.published_at,c.name AS cat_name FROM posts p LEFT JOIN categories c ON c.id=p.category_id ORDER BY p.id DESC");
$rows = $ps->fetchAll();
include __DIR__.'/inc/layout.php';
?>
<div class="flex items-center justify-between mb-4"><h1 class="text-2xl font-bold">Haberler</h1><a class="btn btn-primary" href="post-new.php">Yeni</a></div>
<table class="table"><thead><tr><th>ID</th><th>Başlık</th><th>Kategori</th><th>Durum</th><th>Görsel</th><th>İşlem</th></tr></thead><tbody>
<?php foreach($rows as $r): ?><tr>
  <td><?= e($r['id']) ?></td>
  <td><a class="text-blue-600" href="post-edit.php?id=<?= e($r['id']) ?>"><?= e($r['title']) ?></a></td>
  <td><?= e($r['cat_name'] ?? '-') ?></td>
  <td><?= e($r['status']) ?></td>
  <td><?php if($r['image']): ?><img class="thumb" src="<?= e('../'.$r['image']) ?>"><?php endif; ?></td>
  <td class="flex gap-2">
    <form method="post" onsubmit="return confirm('Silinsin mi?')">
      <?= csrf_field() ?><input type="hidden" name="id" value="<?= e($r['id']) ?>"><input type="hidden" name="action" value="delete"><button class="btn btn-danger">Sil</button>
    </form>
    <a class="btn" href="post-edit.php?id=<?= e($r['id']) ?>">Düzenle</a>
    <?php if($r['status']!=='published'): ?>
      <form method="post"><?= csrf_field() ?><input type="hidden" name="id" value="<?= e($r['id']) ?>"><input type="hidden" name="action" value="publish"><button class="btn btn-primary">Yayınla</button></form>
    <?php else: ?>
      <form method="post"><?= csrf_field() ?><input type="hidden" name="id" value="<?= e($r['id']) ?>"><input type="hidden" name="action" value="unpublish"><button class="btn btn-warning">Taslağa Al</button></form>
    <?php endif; ?>
  </td>
</tr><?php endforeach; ?></tbody></table>
<?php include __DIR__.'/inc/footer.php'; ?>
