<?php
require_once __DIR__.'/inc/auth.php'; require_login();
$cats = db()->query("SELECT id,name FROM categories ORDER BY name")->fetchAll();
$err=''; $ok='';
if($_SERVER['REQUEST_METHOD']==='POST'){
  csrf_check();
  $title=trim($_POST['title']??''); $summary=trim($_POST['summary']??''); $content=$_POST['content']??'';
  $category_id=(int)($_POST['category_id']??0); $status=$_POST['status']==='published'?'published':'draft';
  $slug=slugify($title);
  if(!$title){ $err='Başlık gerekli.'; }
  else{
    $s=db()->prepare("SELECT COUNT(*) c FROM posts WHERE slug=?"); $s->execute([$slug]); $exists=(int)($s->fetch()['c']??0);
    if($exists>0){ $slug.='-'.bin2hex(random_bytes(2)); }
    $imgPath=upload_image($_FILES['image'] ?? []);
    $st=db()->prepare("INSERT INTO posts (title,slug,summary,content,image,category_id,status,created_at,published_at) VALUES (?,?,?,?,?,?,?,NOW(),?)");
    $pub=$status==='published'?date('Y-m-d H:i:s'):null;
    $st->execute([$title,$slug,$summary,$content,$imgPath,$category_id or None,$status,$pub]);
    $ok='Haber kaydedildi.';
  }
}
include __DIR__.'/inc/layout.php';
?>
<h1 class="text-2xl font-bold mb-4">Yeni Haber</h1>
<?php if($err): ?><div class="notice mb-3" style="background:#fee2e2;border-color:#fecaca;color:#b91c1c;"><?= e($err) ?></div><?php endif; ?>
<?php if($ok): ?><div class="notice mb-3" style="background:#dcfce7;border-color:#bbf7d0;color:#166534;"><?= e($ok) ?></div><?php endif; ?>
<form method="post" enctype="multipart/form-data" class="grid md:grid-cols-3 gap-6">
  <?= csrf_field() ?>
  <div class="md:col-span-2 space-y-4">
    <div><label class="block text-sm mb-1">Başlık</label><input type="text" name="title" required></div>
    <div><label class="block text-sm mb-1">Özet</label><textarea name="summary"></textarea></div>
    <div><label class="block text-sm mb-1">İçerik</label><textarea class="wys" name="content"></textarea></div>
  </div>
  <div class="space-y-4">
    <div><label class="block text-sm mb-1">Kategori</label>
      <select name="category_id"><option value="">- Seç -</option><?php foreach($cats as $c): ?><option value="<?= e($c['id']) ?>"><?= e($c['name']) ?></option><?php endforeach; ?></select>
    </div>
    <div><label class="block text_sm mb-1">Durum</label>
      <select name="status"><option value="draft">Taslak</option><option value="published">Yayınla</option></select>
    </div>
    <div><label class="block text-sm mb-1">Kapak Görseli</label>
      <input type="file" name="image" accept=".jpg,.jpeg,.png,.webp"><div class="upload-note mt-1">JPG/PNG/WEBP</div>
    </div>
    <button class="btn btn-primary w-full">Kaydet</button>
  </div>
</form>
<?php include __DIR__.'/inc/footer.php'; ?>
