<?php
require_once __DIR__.'/inc/auth.php'; require_login();
$id=(int)($_GET['id']??0);
$ps=db()->prepare("SELECT * FROM posts WHERE id=? LIMIT 1"); $ps->execute([$id]); $post=$ps->fetch(); $ps->closeCursor();
if(!$post){ die('Haber bulunamadı.'); }
$cats = db()->query("SELECT id,name FROM categories ORDER BY name")->fetchAll();
$err=''; $ok='';
if($_SERVER['REQUEST_METHOD']==='POST'){
  csrf_check();
  $title=trim($_POST['title']??''); $summary=trim($_POST['summary']??''); $content=$_POST['content']??'';
  $category_id=(int)($_POST['category_id']??0); $status=$_POST['status']==='published'?'published':'draft';
  if(!$title){ $err='Başlık gerekli.'; }
  else{
    $imgPath=$post['image'];
    if(!empty($_FILES['image']['name'])){ $new=upload_image($_FILES['image']); if($new){ $imgPath=$new; } }
    $st=db()->prepare("UPDATE posts SET title=?, summary=?, content=?, image=?, category_id=?, status=?, updated_at=NOW(), published_at=IF(?='published', IFNULL(published_at,NOW()), NULL) WHERE id=?");
    $st->execute([$title,$summary,$content,$imgPath,$category_id or None,$status,$status,$id]); $ok='Güncellendi.';
    if(isset($_POST['refresh_slug']) && $_POST['refresh_slug']=='1'){
      $slug=slugify($title); $s=db()->prepare("SELECT COUNT(*) c FROM posts WHERE slug=? AND id<>?"); $s->execute([$slug,$id]); $exists=(int)($s->fetch()['c']??0);
      if($exists>0){ $slug.='-'.bin2hex(random_bytes(2)); } db()->prepare("UPDATE posts SET slug=? WHERE id=?")->execute([$slug,$id]);
    }
  }
}
include __DIR__.'/inc/layout.php';
?>
<h1 class="text-2xl font-bold mb-4">Haber Düzenle #<?= e($post['id']) ?></h1>
<?php if($err): ?><div class="notice mb-3" style="background:#fee2e2;border-color:#fecaca;color:#b91c1c;"><?= e($err) ?></div><?php endif; ?>
<?php if($ok): ?><div class="notice mb-3" style="background:#dcfce7;border-color:#bbf7d0;color:#166534;"><?= e($ok) ?></div><?php endif; ?>
<form method="post" enctype="multipart/form-data" class="grid md:grid-cols-3 gap-6">
  <?= csrf_field() ?>
  <div class="md:col-span-2 space-y-4">
    <div><label class="block text-sm mb-1">Başlık</label><input type="text" name="title" value="<?= e($post['title']) ?>" required></div>
    <div><label class="block text-sm mb-1">Özet</label><textarea name="summary"><?= e($post['summary']) ?></textarea></div>
    <div><label class="block text-sm mb-1">İçerik</label><textarea class="wys" name="content"><?= e($post['content']) ?></textarea></div>
  </div>
  <div class="space-y-4">
    <div><label class="block text-sm mb-1">Kategori</label>
      <select name="category_id"><option value="">- Seç -</option><?php foreach($cats as $c): ?><option value="<?= e($c['id']) ?>" <?= $post['category_id']==$c['id']?'selected':'' ?>><?= e($c['name']) ?></option><?php endforeach; ?></select>
    </div>
    <div><label class="block text-sm mb-1">Durum</label>
      <select name="status"><option value="draft" <?= $post['status']==='draft'?'selected':'' ?>>Taslak</option><option value="published" <?= $post['status']==='published'?'selected':'' ?>>Yayınla</option></select>
    </div>
    <div><label class="block text-sm mb-1">Kapak Görseli</label>
      <?php if($post['image']): ?><img class="thumb mb-1" src="<?= e('../'.$post['image']) ?>"><?php endif; ?>
      <input type="file" name="image" accept=".jpg,.jpeg,.png,.webp"><div class="upload-note mt-1">JPG/PNG/WEBP</div>
    </div>
    <label class="flex items-center gap-2"><input type="checkbox" name="refresh_slug" value="1"> Başlığa göre slug’ı güncelle</label>
    <button class="btn btn-primary w-full">Güncelle</button>
  </div>
</form>
<?php include __DIR__.'/inc/footer.php'; ?>
